// objectSort.java
// demonstruje sortowanie obiektw (przy uyciu sortowania przez wstawianie)
// uruchomienie programu: C>java ObjectSortApp
////////////////////////////////////////////////////////////////
class Person
   {
   private String lastName;           // nazwisko
   private String firstName;          // imi
   private int age;                   // wiek
//--------------------------------------------------------------
   public Person(String last, String first, int a)
      {                               // konstruktor
      lastName = last;
      firstName = first;
      age = a;
      }
//--------------------------------------------------------------
   public void displayPerson()
      {
      System.out.print("   Nazwisko: " + lastName);
      System.out.print(", Imi: " + firstName);
      System.out.println(", Wiek: " + age);
      }
//--------------------------------------------------------------
   public String getLast()           // pobierz nazwisko
      { return lastName; }
   }  // koniec klasy Person
////////////////////////////////////////////////////////////////
class ArrayInOb
   {
   private Person[] a;               // referencja do tablicy
   private int nElems;               // liczba elementw tablicy
//--------------------------------------------------------------
   public ArrayInOb(int max)         // konstruktor
      {
      a = new Person[max];               // tworzymy tablic
      nElems = 0;                        // na razie brak elementw
      }
//--------------------------------------------------------------
// wstawienie rekordu do tablicy
   public void insert(String last, String first, int age)
      {
      a[nElems] = new Person(last, first, age);
      nElems++;                          // zwikszamy licznik elementw
      }
//--------------------------------------------------------------
   public void display()             // wypisujemy zawarto tablicy
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         a[j].displayPerson();          // ...wypisz jego warto
      }
//--------------------------------------------------------------
   public void insertionSort()
      {
      int in, out;

      for(out=1; out<nElems; out++)
         {
         Person temp = a[out];       // out to pierwszy nieposortowany element
         in = out;                   // zaczynamy od out

         while(in>0 &&               // pki nie znalelimy mniejszego
               a[in-1].getLast().compareTo(temp.getLast())>0)
            {
            a[in] = a[in-1];         // przesuwamy element o w prawo
            --in;                    // przesuwamy si w lewo
            }
         a[in] = temp;               // wstawiamy wyrniony element
         }  // koniec ptli for
      }  // koniec insertionSort()
//--------------------------------------------------------------
   }  // koniec klasy ArrayInOb
////////////////////////////////////////////////////////////////
class ObjectSortApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;             // rozmiar tablicy
      ArrayInOb arr;                 // referencja do tablicy
      arr = new ArrayInOb(maxSize);  // tworzymy tablic

      arr.insert("Evans", "Patty", 24);
      arr.insert("Smith", "Doc", 59);
      arr.insert("Smith", "Lorraine", 37);
      arr.insert("Smith", "Paul", 37);
      arr.insert("Yee", "Tom", 43);
      arr.insert("Hashimoto", "Sato", 21);
      arr.insert("Stimson", "Henry", 29);
      arr.insert("Velasquez", "Jose", 72);
      arr.insert("Vang", "Minh", 22);
      arr.insert("Creswell", "Lucinda", 18);

      System.out.println("Przed posortowaniem:");
      arr.display();                 // wypisujemy elementy

      arr.insertionSort();           // sortujemy je

      System.out.println("Po posortowaniu:");
      arr.display();                 // i znw wypisujemy
      }  // koniec main()
   }  // koniec klasy ObjectSortApp
////////////////////////////////////////////////////////////////
